/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.operaciones;

import com.ibm.icu.text.SimpleDateFormat;
import ec.gob.sri.anexo.validacion.modelo.ContextoErrores;
import ec.gob.sri.anexo.validacion.modelo.ErrorDetalleAnexoValidacion;
import ec.gob.sri.anexo.validacion.modelo.ErrorValidacion;
import ec.gob.sri.anexo.validacion.modelo.WarningValidacion;
import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.validacion.ValidacionATS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class OperacionValidacionAnexo
implements IRunnableWithProgress {
    private static final int LIMITE_ADVERTENCIAS = 500;
    private File archivoXML;
    private File archivoErroresInformacion = null;
    private ResultadoValidacion resultadoValidacionEsquema = null;
    private boolean tieneErrores = Boolean.FALSE;
    private Boolean tieneWarnings = Boolean.FALSE;

    public OperacionValidacionAnexo(File archivoXML) {
        this.archivoXML = archivoXML;
    }

    public File getArchivoErroresInformacion() {
        return this.archivoErroresInformacion;
    }

    public ResultadoValidacion getResultadoValidacionEsquema() {
        return this.resultadoValidacionEsquema;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        String separadorArchivo;
        monitor.beginTask("Preparando la validaci\u00f3n", -1);
        Thread.sleep(1000L);
        monitor.setTaskName("Aplicando validaci\u00f3n de esquema");
        Thread.sleep(500L);
        ResultadoValidacion resultado = null;
        ValidacionATS validacionATS = new ValidacionATS(this.archivoXML);
        try {
            resultado = validacionATS.validarEsquema();
        }
        catch (FileNotFoundException e) {
            monitor.done();
            PluginLogger.logError((String)"Archivo no existente.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e);
            throw new InterruptedException("El archivo '" + this.archivoXML.getAbsolutePath() + "' no existe.");
        }
        if (resultado != null && (resultado.tieneVariosErrores() || resultado.tieneVariasAdvertencias())) {
            this.resultadoValidacionEsquema = resultado;
            monitor.done();
            return;
        }
        String tempHome = System.getProperty("java.io.tmpdir");
        tempHome = tempHome.endsWith(separadorArchivo = System.getProperty("file.separator")) ? tempHome : String.valueOf(tempHome) + separadorArchivo;
        File outFile = new File(String.format("%sATS_%s.txt", tempHome, new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date())));
        LinkedList<Map<Object, ErrorDetalleAnexoValidacion>> lstErt = new LinkedList<Map<Object, ErrorDetalleAnexoValidacion>>();
        LinkedHashSet<WarningValidacion> lstWarn = new LinkedHashSet<WarningValidacion>();
        monitor.setTaskName("Validando la duplicidad de la informaci\u00f3n");
        Thread.sleep(500L);
        PluginLogger.logInfo((String)" VALIDAR DUPLICADOS", (String)"ec.gob.sri.dimm.ats.ui");
        ContextoErrores ctxErrores01 = validacionATS.validarDuplicados();
        if (ctxErrores01.isHasErrors()) {
            this.tieneErrores = Boolean.TRUE;
            lstErt.add(ctxErrores01.getErroresAcumulados());
        }
        monitor.setTaskName("Validando la integridad de la informaci\u00f3n");
        Thread.sleep(500L);
        ContextoErrores ctxErrores = validacionATS.validarInformacion();
        if (ctxErrores.isHasErrors()) {
            this.tieneErrores = Boolean.TRUE;
            lstErt.add(ctxErrores.getErroresAcumulados());
        }
        if (ctxErrores.getListaWarningsAcumulados().size() > 0) {
            this.tieneWarnings = Boolean.TRUE;
            lstWarn.addAll(ctxErrores.getListaWarningsAcumulados());
        }
        this.writeAllMessages(outFile, monitor, lstErt, lstWarn);
        monitor.done();
    }

    private void writeAllMessages(File outFile, IProgressMonitor monitor, LinkedList<Map<Object, ErrorDetalleAnexoValidacion>> errors, LinkedHashSet<WarningValidacion> warnings) throws InterruptedException {
        PluginLogger.logInfo((String)("Se escribiran ERR:" + errors.size() + " WARNINGS:" + warnings.size()), (String)"ec.gob.sri.dimm.ats.ui");
        if (!errors.isEmpty() || !warnings.isEmpty()) {
            try {
                PrintWriter writer = new PrintWriter(outFile);
                writer.format("ARCHIVO VALIDADO: %s", this.archivoXML.getAbsolutePath());
                writer.print("Se escribiran ERR:" + errors.size() + " WARNINGS:" + warnings.size());
                if (!warnings.isEmpty()) {
                    writer.println();
                    writer.println("ADVERTENCIAS:");
                }
                int contador = 0;
                for (WarningValidacion warningValidacion : warnings) {
                    if (contador > 500) continue;
                    writer.println(warningValidacion.getDescripcion());
                    ++contador;
                }
                if (!errors.isEmpty()) {
                    writer.println();
                    writer.println("ERRORES:");
                }
                for (Map map : errors) {
                    for (Object key : map.keySet()) {
                        writer.println(key.toString());
                        for (ErrorValidacion error : ((ErrorDetalleAnexoValidacion)map.get(key)).getListaErrores()) {
                            writer.println(error.getDescripcion());
                        }
                    }
                }
                writer.flush();
                writer.close();
                this.archivoErroresInformacion = outFile;
            }
            catch (FileNotFoundException e) {
                monitor.done();
                PluginLogger.logError((String)"Error al escribir el archivo de errores", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e);
                throw new InterruptedException("No se puede escribir el archivo de errores.");
            }
        }
    }

    public boolean isTieneErrores() {
        return this.tieneErrores;
    }

    public void setTieneErrores(boolean tieneErrores) {
        this.tieneErrores = tieneErrores;
    }

    public Boolean isTieneWarnings() {
        return this.tieneWarnings;
    }
}

